IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_ATUALIZA_SALDO_CONVENIADO_PARC]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_ATUALIZA_SALDO_CONVENIADO_PARC]
GO

/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20221213
'Nome................: P_ATUALIZA_SALDO_CONVENIADO_PARC 
'Job.................: Linx - Manutencao madrugada / Executada por : P_ATUALIZA_SALDO_CONVENIADO_PARC
'Objetivo............: Atualizar saldo de conveniados parcelado. 
.....................: PROCEDURE PARA FECHAR AS VENDA DO CONVNIO COM A DATA DE FECHAMENTO OU AGENDAMENTO DO CONVNIO
'Tabelas.............: RC_CLI_CONV_RC_CLI
'Dt Criao..........: 2022-12-13
'Dt Ult Alteraco....: 
'Alterado por........: Marcos Barros
'Criado por..........: 
'=======================================================================================

--SELECT * FROM RC_CLI_CONV_RC_CLI WHERE CD_EMP = 1 AND CD_CLI = 73384
--EXEC P_ATUALIZA_SALDO_CONVENIADO_PARC
*/

CREATE PROCEDURE P_ATUALIZA_SALDO_CONVENIADO_PARC AS

	DECLARE @DT_MES_ANT					AS DATETIME
	DECLARE @DT_MES_ATU					AS DATETIME
	DECLARE @FLAG_FECHA_CONV_AUTOMATICO AS INT
	DECLARE @FLAG_IG_FECHA_CONV_PBM_AUTOMATICO AS INT
	DECLARE @ULTDIAMES INT
	DECLARE @CTR_PARCELAMENTO INT
	DECLARE @CD_EMP INT
	DECLARE @CD_CLI INT
	DECLARE @CD_CONV INT


--confirmando a entrega de cartao 
	UPDATE
		RC_CLI_FIDELI_CARTAO_SOLIC
	SET 
		RC_CLI_FIDELI_CARTAO_SOLIC.STS_SOLIC=1
	FROM
		RC_CLI_FIDELI_CARTAO_SOLIC INNER JOIN RC_CLI_FIDELI_CARTAO_CONF_SOLIC ON
		RC_CLI_FIDELI_CARTAO_SOLIC.CD_SOLIC = RC_CLI_FIDELI_CARTAO_CONF_SOLIC.CD_SOLIC
		INNER JOIN RC_CLI_FIDELI_CARTAO_CONF ON
		RC_CLI_FIDELI_CARTAO_CONF_SOLIC.CD_CONF = RC_CLI_FIDELI_CARTAO_CONF.CD_CONF 
	WHERE
		RC_CLI_FIDELI_CARTAO_SOLIC.STS_SOLIC=0
	--Fim
SET @CTR_PARCELAMENTO = ISNULL((SELECT VALOR FROM PRC_EMP_CONFIG WHERE PRC_EMP_CONFIG.CD_CHAVE = 'FLAG_CONTROLE_SALDO_CONVENIADO_PARCELAMENTO'),0)


	CREATE TABLE #RS_DT_FECH (
				CD_EMP INT, 
				CD_CONV INT, 
				DT_FECH_MES_ANT DATETIME, 
				DT_FECH DATETIME
				PRIMARY KEY (CD_EMP, CD_CONV))

		CREATE TABLE #RS_CLIENTES(
								  CD_EMP INT,
								  CD_CLI INT,
								  VLR_VENDA MONEY,
								  CD_CONV INT)
	
		CREATE TABLE #RS_CLIENTES_PENDENTE(
								  CD_EMP INT,
								  CD_CLI INT,
								  CD_CONV INT)
	   
								  
		SET @DT_MES_ANT = DATEADD(MONTH,-1,GETDATE())
		SET @DT_MES_ATU = CONVERT(CHAR(10),GETDATE(),112)

		SET @ULTDIAMES = (SELECT CONVERT(CHAR(10),DBO.F_FINAL_MES(@DT_MES_ANT),112))



IF @CTR_PARCELAMENTO = 0  -- Parcelamento compe saldo
BEGIN
		/*CREATE TABLE #RS_DT_FECH (
				CD_EMP INT, 
				CD_CONV INT, 
				DT_FECH_MES_ANT DATETIME, 
				DT_FECH DATETIME
				PRIMARY KEY (CD_EMP, CD_CONV))

		CREATE TABLE #RS_CLIENTES(
								  CD_EMP INT,
								  CD_CLI INT,
								  VLR_VENDA MONEY,
								  CD_CONV INT)
	
		CREATE TABLE #RS_CLIENTES_PENDENTE(
								  CD_EMP INT,
								  CD_CLI INT,
								  CD_CONV INT)
	   
								  
		SET @DT_MES_ANT = DATEADD(MONTH,-1,GETDATE())
		SET @DT_MES_ATU = CONVERT(CHAR(10),GETDATE(),112)

		SET @ULTDIAMES = (SELECT CONVERT(CHAR(10),DBO.F_FINAL_MES(@DT_MES_ANT),112))*/
		
		INSERT INTO #RS_CLIENTES_PENDENTE
					SELECT 
						CD_EMP,
						CD_CLI,
						CD_CONV
					FROM
						RC_CLI_CONV_RC_CLI_SALDO_PENDENTE

		--ZERADO OS SALDO DE TODOS OS CLIENTES
		--FOI CRIADO UM CURSOR PARA NAO TRAVAR OS DEMAIS USUARIOS DO SISTEMA
		--POIS ESTAREMOS ATUALIZANDO LINHA A LINHA
		SET NOCOUNT ON
		DECLARE CONVENIO CURSOR FAST_FORWARD FOR SELECT 
													DISTINCT RC_CLI_CONV_RC_CLI.CD_EMP, RC_CLI_CONV_RC_CLI.CD_CLI ,RC_CLI_CONV_RC_CLI.CD_CONV
												  FROM 
													RC_CLI_CONV_RC_CLI INNER JOIN #RS_CLIENTES_PENDENTE P ON
													RC_CLI_CONV_RC_CLI.CD_EMP = P.CD_EMP AND
													RC_CLI_CONV_RC_CLI.CD_CLI = P.CD_CLI AND
													RC_CLI_CONV_RC_CLI.CD_CONV=P.CD_CONV
												  WHERE 
													RC_CLI_CONV_RC_CLI.VLR_DEB <> 0
		OPEN CONVENIO
		FETCH NEXT FROM CONVENIO INTO @CD_EMP, @CD_CLI,@CD_CONV
		WHILE @@FETCH_STATUS=0
			BEGIN
				UPDATE
					RC_CLI_CONV_RC_CLI
				SET
					VLR_DEB = 0,
					DT_ULT_ALT=GETDATE()
				WHERE
					CD_EMP = @CD_EMP
					AND CD_CLI = @CD_CLI
					AND CD_CONV=@CD_CONV
				--PROXIMO REGISTRO
				FETCH NEXT FROM CONVENIO INTO @CD_EMP, @CD_CLI,@CD_CONV
			END
		--FECHANDO CURSOS
		CLOSE CONVENIO;
		--DESALOCANDO CURSOS DA MEMORIA
		DEALLOCATE CONVENIO;
		
		---------------------------------------------------------------------------------------------------------
		--CAPTURANDO AS DATAS DE FECHAMENTO DO CONVNIO
		--------------------------------------------------------------------------------------------------------- 
		PRINT 'BUSCANDO CONVENIO PARA FECHAMENTO'
		INSERT INTO #RS_DT_FECH
		SELECT
			DISTINCT 
			RC_CLI_CONV.CD_EMP,
			RC_CLI_CONV.CD_CONV,			
			DATEADD (MONTH,-1,RC_CLI_CONV.DT_PROX_FECHAMENTO),
			RC_CLI_CONV.DT_PROX_FECHAMENTO
		FROM         	
			RC_CLI_CONV 
		WHERE     
 			 RC_CLI_CONV.DIA_FAT > 0
 			-- AND  RC_CLI_CONV.TP_CONV = (CASE WHEN @FLAG_IG_FECHA_CONV_PBM_AUTOMATICO = 1 THEN 0 ELSE RC_CLI_CONV.TP_CONV END)

		---------------------------------------------------------------------------------------------------------
		--ALTERANDO AS DATAS DE FECHAMENTO PARA AS DATA AGENDADAS
		---------------------------------------------------------------------------------------------------------
		PRINT 'ALTERANDO DATA DE FECHAMENTO'
		UPDATE FECH SET
				FECH.DT_FECH = (CASE WHEN CONVERT(CHAR(10),AGD_FECH.DT_FECH_AGD, 112) >= CONVERT(CHAR(10),@DT_MES_ATU, 112) THEN 
										CONVERT(CHAR(10),FECH.DT_FECH_MES_ANT, 112) 
								ELSE 
										CONVERT(CHAR(10),AGD_FECH.DT_FECH_AGD, 112) 
								END)	
		FROM #RS_DT_FECH FECH INNER JOIN RC_CLI_CONV_AGD_FECH AGD_FECH ON
				AGD_FECH.CD_EMP = FECH.CD_EMP AND
				AGD_FECH.CD_CONV = FECH.CD_CONV AND
				(LEFT(CONVERT(CHAR(10),AGD_FECH.DT_FECH_CONV, 112),6) = LEFT(CONVERT(CHAR(10),@DT_MES_ATU, 112),6) 				
				 OR
				 LEFT(CONVERT(CHAR(10),AGD_FECH.DT_FECH_CONV, 112),6) = LEFT(CONVERT(CHAR(10),FECH.DT_FECH, 112),6)) 		

		
		---------------------------------------------------------------------------------------------------------
		--REALIZANDO A SOMATORIO DAS PARCELAS
		---------------------------------------------------------------------------------------------------------
		PRINT 'SOMANDO VENDAS'
		INSERT INTO #RS_CLIENTES
		SELECT
			C.CD_EMP,
			C.CD_CLI,
			SUM(ISNULL(C.VLR_CONV,0)) - SUM(ISNULL(RSNCC.VLR_CRED_NCC,0)),
			ISNULL(C.CD_CONV, 0)
		FROM         
			RC_VD_CONV C INNER JOIN #RS_DT_FECH FECH ON 
				C.CD_EMP = FECH.CD_EMP AND 
				C.CD_CONV = FECH.CD_CONV
			LEFT OUTER JOIN ( SELECT 
								RC_VD_CONV_CRED.CD_EMP,
								RC_VD_CONV_CRED.CD_CTR,
								SUM(RC_VD_CONV_CRED.VLR_CRED) AS VLR_CRED_NCC
							FROM 
								RC_VD_CONV_CRED
							GROUP BY
								RC_VD_CONV_CRED.CD_EMP,
								RC_VD_CONV_CRED.CD_CTR) RSNCC ON	
						C.CD_EMP = RSNCC.CD_EMP AND
						C.CD_CTR = RSNCC.CD_CTR  
											
		WHERE    
			 C.ST_FECHVD_CONV in (0)
			 AND CONVERT(CHAR(10),C.DT_FECHA,112) <= FECH.DT_FECH	
		GROUP BY
			C.CD_EMP,
			C.CD_CLI,
			C.CD_CONV
		---------------------------------------------------------------------------------------------------------
		--REALIZANDO OS FECHAMENTO DOS CONVNIOS EM ABERTO
		---------------------------------------------------------------------------------------------------------
		PRINT 'ALTERANDO VALOR DO SALDO EM CONVENIO'
		UPDATE 
			C 
		SET
			C.VLR_DEB = CLI.VLR_VENDA,
			DT_ULT_ALT=getdate()
		FROM         
			RC_CLI_CONV_RC_CLI C INNER JOIN #RS_CLIENTES CLI ON 
				C.CD_EMP = CLI.CD_EMP AND 
				C.CD_CLI = CLI.CD_CLI AND
				C.CD_CONV=CLI.CD_CONV
		WHERE C.VLR_DEB <> CLI.VLR_VENDA

		--DELETANDO OS REGISTROS USADOS ANTERIORMENTE
		DELETE 
			D
		FROM 
			RC_CLI_CONV_RC_CLI_SALDO_PENDENTE D INNER JOIN #RS_CLIENTES_PENDENTE CLI ON
			D.CD_EMP = CLI.CD_EMP AND
			D.CD_CLI = CLI.CD_CLI AND
			D.CD_CONV=CLI.CD_CONV
		--FIM			
			
		DROP TABLE #RS_DT_FECH;
		DROP TABLE #RS_CLIENTES;
END
IF @CTR_PARCELAMENTO = 1  -- Parcelamento compe saldo
BEGIN
			
		INSERT INTO #RS_CLIENTES_PENDENTE
					SELECT 
						CD_EMP,
						CD_CLI,
						CD_CONV
					FROM
						RC_CLI_CONV_RC_CLI_SALDO_PENDENTE

		--ZERADO OS SALDO DE TODOS OS CLIENTES
		--FOI CRIADO UM CURSOR PARA NAO TRAVAR OS DEMAIS USUARIOS DO SISTEMA
		--POIS ESTAREMOS ATUALIZANDO LINHA A LINHA
		SET NOCOUNT ON
		DECLARE CONVENIO CURSOR FAST_FORWARD FOR SELECT 
													DISTINCT RC_CLI_CONV_RC_CLI.CD_EMP, RC_CLI_CONV_RC_CLI.CD_CLI ,RC_CLI_CONV_RC_CLI.CD_CONV
												  FROM 
													RC_CLI_CONV_RC_CLI INNER JOIN #RS_CLIENTES_PENDENTE P ON
													RC_CLI_CONV_RC_CLI.CD_EMP = P.CD_EMP AND
													RC_CLI_CONV_RC_CLI.CD_CLI = P.CD_CLI AND
													RC_CLI_CONV_RC_CLI.CD_CONV=P.CD_CONV
												  WHERE 
													RC_CLI_CONV_RC_CLI.VLR_DEB <> 0
		OPEN CONVENIO
		FETCH NEXT FROM CONVENIO INTO @CD_EMP, @CD_CLI,@CD_CONV
		WHILE @@FETCH_STATUS=0
			BEGIN
				UPDATE
					RC_CLI_CONV_RC_CLI
				SET
					VLR_DEB = 0,
					DT_ULT_ALT=getdate()
				WHERE
					CD_EMP = @CD_EMP
					AND CD_CLI = @CD_CLI
					AND CD_CONV=@CD_CONV
				--PROXIMO REGISTRO
				FETCH NEXT FROM CONVENIO INTO @CD_EMP, @CD_CLI,@CD_CONV
			END
		--FECHANDO CURSOS
		CLOSE CONVENIO;
		--DESALOCANDO CURSOS DA MEMORIA
		DEALLOCATE CONVENIO;
		
		---------------------------------------------------------------------------------------------------------
		--CAPTURANDO AS DATAS DE FECHAMENTO DO CONVNIO
		--------------------------------------------------------------------------------------------------------- 
		PRINT 'BUSCANDO CONVENIO PARA FECHAMENTO'
		INSERT INTO #RS_DT_FECH
		SELECT
			DISTINCT 
			RC_CLI_CONV.CD_EMP,
			RC_CLI_CONV.CD_CONV,			
			DATEADD (MONTH,-1,RC_CLI_CONV.DT_PROX_FECHAMENTO),
			RC_CLI_CONV.DT_PROX_FECHAMENTO
		FROM         	
			RC_CLI_CONV 
		WHERE     
 			 RC_CLI_CONV.DIA_FAT > 0
 			 AND  RC_CLI_CONV.TP_CONV = (CASE WHEN @FLAG_IG_FECHA_CONV_PBM_AUTOMATICO = 1 THEN 0 ELSE RC_CLI_CONV.TP_CONV END)

		---------------------------------------------------------------------------------------------------------
		--ALTERANDO AS DATAS DE FECHAMENTO PARA AS DATA AGENDADAS
		---------------------------------------------------------------------------------------------------------
		PRINT 'ALTERANDO DATA DE FECHAMENTO'
		UPDATE FECH SET
				FECH.DT_FECH = (CASE WHEN CONVERT(CHAR(10),AGD_FECH.DT_FECH_AGD, 112) >= CONVERT(CHAR(10),@DT_MES_ATU, 112) THEN 
										CONVERT(CHAR(10),FECH.DT_FECH_MES_ANT, 112) 
								ELSE 
										CONVERT(CHAR(10),AGD_FECH.DT_FECH_AGD, 112) 
								END)	
		FROM #RS_DT_FECH FECH INNER JOIN RC_CLI_CONV_AGD_FECH AGD_FECH ON
				AGD_FECH.CD_EMP = FECH.CD_EMP AND
				AGD_FECH.CD_CONV = FECH.CD_CONV AND
				(LEFT(CONVERT(CHAR(10),AGD_FECH.DT_FECH_CONV, 112),6) = LEFT(CONVERT(CHAR(10),@DT_MES_ATU, 112),6) 				
				 OR
				 LEFT(CONVERT(CHAR(10),AGD_FECH.DT_FECH_CONV, 112),6) = LEFT(CONVERT(CHAR(10),FECH.DT_FECH, 112),6)) 		

		
		---------------------------------------------------------------------------------------------------------
		--REALIZANDO A SOMATORIO DAS PARCELAS
		---------------------------------------------------------------------------------------------------------
		PRINT 'SOMANDO VENDAS'
		INSERT INTO #RS_CLIENTES
		SELECT
			C.CD_EMP,
			C.CD_CLI,
			SUM(ISNULL(C.VLR_CONV,0)) - SUM(ISNULL(RSNCC.VLR_CRED_NCC,0)),
			C.CD_CONV
		FROM         
			RC_VD_CONV C INNER JOIN #RS_DT_FECH FECH ON 
				C.CD_EMP = FECH.CD_EMP AND 
				C.CD_CONV = FECH.CD_CONV
			LEFT OUTER JOIN ( SELECT 
								RC_VD_CONV_CRED.CD_EMP,
								RC_VD_CONV_CRED.CD_CTR,
								SUM(RC_VD_CONV_CRED.VLR_CRED) AS VLR_CRED_NCC
							FROM 
								RC_VD_CONV_CRED
							GROUP BY
								RC_VD_CONV_CRED.CD_EMP,
								RC_VD_CONV_CRED.CD_CTR) RSNCC ON	
						C.CD_EMP = RSNCC.CD_EMP AND
						C.CD_CTR = RSNCC.CD_CTR  
											
		WHERE    
			 C.ST_FECHVD_CONV in (0)
		--	 AND CONVERT(CHAR(10),C.DT_FECHA,112) <= FECH.DT_FECH  --NO PODE VALIDAR DATA DE FECHAMENTO QUANDO FLAG ESTA MARCADO PARA COMPOR SALDO FUTURO
		GROUP BY
			C.CD_EMP,
			C.CD_CLI,
			C.CD_CONV
		---------------------------------------------------------------------------------------------------------
		--REALIZANDO OS FECHAMENTO DOS CONVNIOS EM ABERTO
		---------------------------------------------------------------------------------------------------------
		PRINT 'ALTERANDO VALOR DO SALDO EM CONVENIO'
		UPDATE 
			C 
		SET
			C.VLR_DEB = CLI.VLR_VENDA,
			DT_ULT_ALT=getdate()
		FROM         
			RC_CLI_CONV_RC_CLI C INNER JOIN #RS_CLIENTES CLI ON 
				C.CD_EMP = CLI.CD_EMP AND 
				C.CD_CLI = CLI.CD_CLI AND
				C.CD_CONV=CLI.CD_CONV
		
		--DELETANDO OS REGISTROS USADOS ANTERIORMENTE
		DELETE 
			D
		FROM 
			RC_CLI_CONV_RC_CLI_SALDO_PENDENTE D INNER JOIN #RS_CLIENTES_PENDENTE CLI ON
			D.CD_EMP = CLI.CD_EMP AND
			D.CD_CLI = CLI.CD_CLI AND
			D.CD_CONV=CLI.CD_CONV
		--FIM			
			
		DROP TABLE #RS_DT_FECH;
		DROP TABLE #RS_CLIENTES;
END

CREATE TABLE #RSDEMITEPROV(CD_CONV_DEMITE INT, CD_CONV INT, CD_EMP INT, CD_CLI INT)
INSERT INTO #RSDEMITEPROV
SELECT
	WEB_CONV_DEMITE.CD_CONV_DEMITE,
	WEB_CONV_DEMITE.CD_CONV,
	WEB_CONV_DEMITE_RC_CLI.CD_EMP,
	WEB_CONV_DEMITE_RC_CLI.CD_CLI 
FROM
	WEB_CONV_DEMITE INNER JOIN WEB_CONV_DEMITE_RC_CLI ON
	WEB_CONV_DEMITE.CD_CONV_DEMITE = WEB_CONV_DEMITE_RC_CLI.CD_CONV_DEMITE
WHERE
	WEB_CONV_DEMITE.FLAG_PROCESSADO=0

--BLOQUEANDO CONVENIADO PENDENTES 
	PRINT 'UPDATE 9 ' + CONVERT(VARCHAR, GETDATE(), 108);
	DECLARE CONVENIOBLQ CURSOR FAST_FORWARD FOR 
	SELECT DISTINCT CD_EMP, CD_CLI, CD_CONV
	FROM #RSDEMITEPROV
									
	OPEN CONVENIOBLQ
			
	FETCH NEXT FROM CONVENIOBLQ INTO @CD_EMP, @CD_CLI, @CD_CONV
	WHILE @@FETCH_STATUS=0
		BEGIN
			UPDATE
				RC_CLI_CONV_RC_CLI				
			SET 
				RC_CLI_CONV_RC_CLI.STS_CRED=1,
				RC_CLI_CONV_RC_CLI.FLAG_CONVENIADO_DEMISSAO=1,
				DT_ULT_ALT=getdate()
			WHERE
				RC_CLI_CONV_RC_CLI.CD_EMP=@CD_EMP
				AND RC_CLI_CONV_RC_CLI.CD_CONV=@CD_CONV
				AND RC_CLI_CONV_RC_CLI.CD_CLI=@CD_CLI
				AND RC_CLI_CONV_RC_CLI.STS_CRED = 0

			UPDATE
				RC_CLI
			SET 
				RC_CLI.STS_CRED=1,
				RC_CLI.DT_ULT_ALT = getdate(),
				RC_CLI.FLAG_CONVENIADO_DEMISSAO=1
			FROM
				RC_CLI
			WHERE
				RC_CLI.CD_EMP=@CD_EMP
				AND RC_CLI.CD_CLI=@CD_CLI
				AND RC_CLI.STS_CRED=0		

			--PROXIMO REGISTRO
			FETCH NEXT FROM CONVENIOBLQ INTO @CD_EMP, @CD_CLI, @CD_CONV
		END
		
		--FECHANDO CURSOS
		CLOSE CONVENIOBLQ;
		--DESALOCANDO CURSOS DA MEMORIA
		DEALLOCATE CONVENIOBLQ;
--MARCANDO COMO PROCESSADO
UPDATE
	WEB_CONV_DEMITE
SET 
	FLAG_PROCESSADO=1
FROM
	WEB_CONV_DEMITE INNER JOIN #RSDEMITEPROV D ON
	WEB_CONV_DEMITE.CD_CONV_DEMITE = D.CD_CONV_DEMITE

DROP TABLE 	#RSDEMITEPROV
PRINT 'P_ATUALIZA_SALDO_CONVENIADO FINALIZADA!';